taskID <- as.integer(Sys.getenv("SLURM_ARRAY_TASK_ID"))
require(Matrix)
require(igraph)

#taskID <- 1

#determine graph size and density settings by array number
#epsilon = c(0.3,0.6, 0.9)
#prop = c(0.25,0.5,0.75)

#sim_grid <- expand.grid(epsilon, prop)

#block_params <- sim_grid[as.integer(taskID/100)+1,]


Np = c(6, 10, 16)
N = c(1000,5000,10000)

#m = c(1,2,5)

sim_grid <- expand.grid(N, Np)

pop_params <- sim_grid[as.integer(taskID/100)+1,]



best_RDS_sample_craw_multiple_bare<- function(net, coupons, seeds, rate, interview_limit = NULL, covariates = NULL ){
  #RDS sample simulator
  
  rec_cov <- NULL
  
  size = length(net[,1])
  
  if(is.null(interview_limit)){
    interview_limit = size
  }
  
  sample = T
  recruited <- seeds
  network_observed <- Matrix(NA, size,size)
  direction_network_observed <- Matrix(NA, size,size)
  coupon_vector <- rep(0, size)
  coupon_vector[seeds] <- coupons
  degrees <- rowSums(net) 
  wait_time_mat <- matrix(NA,size,size)
  #Insert wait times for all seed recruits
  
  #identify neighbors of seeds
  for (seed in seeds){
    
    #identify neighbors of the seed
    neighbors <- which(net[seed,] ==1)
    
    #check if potential recruits were already recruited
    potentials <-  neighbors[!(neighbors %in% recruited)]
    
    #generate wait times
    wait_times <- rexp(length(potentials), rate = rate)
    
    #add the wait times to the wait time matrix
    wait_time_mat[seed, potentials] <- wait_times
    
    
    #set the wait times going to recruited to NA
    wait_time_mat[,seed] <- NA
    
  }
  
  
  
  #store coupon matrix and times
  times <- rep(0,length(seeds))
  coupon_matrix <- Matrix(0,size, size)
  k <- length(seeds) + 1
  
  
  while (sample){
    
    
    #Fill in coupon matrix
    coupon_matrix[,k] <- as.numeric(coupon_vector > 0)
    
    
    #increment time
    k <- k+1
    
    # now let's pick out the next observed edge
    r_c <- which(min(wait_time_mat, na.rm = T) == wait_time_mat, arr.ind = T)
    time <- min(wait_time_mat, na.rm = T)
    
    #add time
    times <- c(times, time)
    
    #fill in RDS directed network
    direction_network_observed[r_c[1], r_c[2]] <- 1
    
    #fill in the observed edge in symmetric network
    network_observed[r_c[1], r_c[2]] <- 1
    network_observed[r_c[2], r_c[1]] <- 1
    
    #add recruited to recruited list
    recruited <- c(recruited, r_c[2])
    newly_recruited <- r_c[2]
    
    #Give coupons to recruited 
    coupon_vector[r_c[2]] <- coupons
    
    #subtract a coupon from the recruiter
    coupon_vector[r_c[1]] <-  coupon_vector[r_c[1]] - 1
    
    #set wait times associated with a node with no coupons to NA
    if(length(r_c) > 0){
      if(coupon_vector[r_c[1]] == 0){
        wait_time_mat[r_c[1],] <- NA
      }
    }
    
    #set the wait times going to recruited to NA
    wait_time_mat[,r_c[2]] <- NA
    
    #increment time
    wait_time_mat[!is.na(wait_time_mat)]<- wait_time_mat[!is.na(wait_time_mat)] - time

    #generate wait times for potential edges of newly recruited node
    
    #identify neighbors of newly_recruited
    neighbors <- which(net[newly_recruited,] ==1)
    
    #check if potential recruits were already recruited
    potentials <-  neighbors[!(neighbors %in% recruited)]
    
    #generate wait times
    wait_times <- rexp(length(potentials), rate = rate)
    
    #add the wait times to the wait time matrix
    wait_time_mat[newly_recruited, potentials] <- wait_times
    
    sample = !( all(coupon_vector==0) |
                  all(is.na(wait_time_mat)) | 
                  length(recruited) >= interview_limit )
    
  }
  
  
  #arrange the coupon matrix and cut off time at last recruitment event
  final_coupon_matrix <- coupon_matrix[recruited,1:length(recruited)]
  
  #let's rearrange the observed network so it lines up with the recruitment order
  network_recruited <- network_observed
  network_recruited[which(is.na(network_observed))] <- 0 
  network_recruited <- network_recruited[recruited,recruited]
  
  #true network
  true_network <- net[recruited, recruited]
  
  #covariates of recruited participants
  if(!is.null(covariates)){
    rec_cov <- covariates[recruited]
  }
  
  return(list(rec_cov = rec_cov,
              true_network = true_network, 
              network_recruited = network_recruited, 
              recruited = recruited, 
              coupon_vector = coupon_vector, 
              times = times,
              degrees = degrees, 
              final_coupon_matrix = final_coupon_matrix, seeds = seeds,k=k ))
}


N <- as.numeric(pop_params[1])
Np <- as.numeric(pop_params[2])

graph <- sample_pa(
  n = N,
  power = 1,
  m = m,
  out.dist = NULL,
  out.seq = NULL,
  out.pref = FALSE,
  zero.appeal = 0,
  directed = FALSE,
  start.graph = NULL
)


adj_matrix <- as_adjacency_matrix(
  graph,
  type = c("both", "upper", "lower"),
  attr = NULL,
  edges = FALSE,
  names = TRUE,
  sparse = igraph_opt("sparsematrices")
)



#READ IN DATA AND SIMULATE TIMES

rds <- best_RDS_sample_craw_multiple_bare(adj_matrix, 5, sample(1:N, 3), 1, 
                                          interview_limit = 100, 
                                          covariates = NULL)

saveRDS(list(rds = rds, in_prob = NA, m= m ) , paste0('rds_', taskID, '.rds')) 
